# SPDX-FileCopyrightText: 2014-2025 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

from pathlib import Path
from typing import IO, Any

from . import BaseImage


class Raw(BaseImage):
    """represents a "RAW" disk image"""

    def __init__(self, inputfile: IO[bytes]) -> None:
        BaseImage.__init__(self)
        self._inputfile = inputfile
        self._path = Path(inputfile.name)

    @BaseImage.hashed
    def hash(self) -> tuple[Any, ...]:
        return (Raw, self._inputfile)

    def _create(self, path: Path) -> None:
        pass

    def volume_size(self) -> int:
        return self.file_size()
